<?php

use App\Http\Controllers\AdminController;
use App\Http\Controllers\Backend\AllowanceController;
use App\Http\Controllers\Backend\DeductionController;
use App\Http\Controllers\Backend\DepartmentController;
use App\Http\Controllers\Backend\DesignationController;
use App\Http\Controllers\Backend\EmployeeController;
use App\Http\Controllers\Backend\EmployeeLoanController;
use App\Http\Controllers\Backend\FoodController;
use App\Http\Controllers\Backend\KitchenController;
use App\Http\Controllers\Backend\MealController;
use App\Http\Controllers\Backend\PayrollController;
use App\Http\Controllers\Backend\PosController;
use App\Http\Controllers\Backend\ProductController;
use App\Http\Controllers\Backend\PurchaseController;
use App\Http\Controllers\Backend\RegisterController;
use App\Http\Controllers\Backend\ReportController;
use App\Http\Controllers\Backend\SupplierController;
use App\Http\Controllers\Backend\UnitController;
use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    return view('welcome');
});

Route::get('/dashboard', function () {
    return view('index');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

require __DIR__.'/auth.php';
Route::get('/admin/logout', [AdminController::class, 'AdminDestroy'])->name('admin.logout');

Route::get('/logout', [AdminController::class, 'AdminLogoutPage'])->name('admin.logout.page');
Route::middleware(['auth'])->group(function(){

    Route::get('/admin/profile', [AdminController::class, 'AdminProfile'])->name('admin.profile');

    Route::post('/admin/profile/store', [AdminController::class, 'AdminProfileStore'])->name('admin.profile.store');


    Route::get('/change/password', [AdminController::class, 'ChangePassword'])->name('change.password');

    Route::post('/update/password', [AdminController::class, 'UpdatePassword'])->name('update.password');


    ///Unit All Route
    Route::controller(UnitController::class)->group(function(){

        Route::get('/all/unit','AllUnit')->name('all.unit');
        Route::post('/store/unit','StoreUnit')->name('units.store');
        Route::get('/edit/unit/{id}','EditUnit')->name('edit.units');
        Route::post('/update/unit/{id}','UpdateUnit')->name('units.update');
        Route::get('/delete/unit/{id}','DeleteUnit')->name('delete.units');

    });

/// Supplier All Route
    Route::controller(SupplierController::class)->group(function(){

        Route::get('/all/supplier','AllSupplier')->name('all.supplier');
        Route::get('/add/supplier','AddSupplier')->name('add.supplier');
        Route::post('/store/supplier','StoreSupplier')->name('supplier.store');
        Route::get('/edit/supplier/{id}','EditSupplier')->name('edit.supplier');
        Route::post('/update/supplier','UpdateSupplier')->name('supplier.update');
        Route::get('/delete/supplier/{id}','DeleteSupplier')->name('delete.supplier');
        Route::get('/details/supplier/{id}','DetailsSupplier')->name('details.supplier');
    });

///Product All Route
    Route::controller(ProductController::class)->group(function(){

        Route::get('/all/product','AllProduct')->name('all.product');
        Route::get('/add/product','AddProduct')->name('add.product');
        Route::post('/store/product','StoreProduct')->name('product.store');
        Route::get('/edit/product/{id}','EditProduct')->name('edit.product');
        Route::post('/update/product','UpdateProduct')->name('product.update');
        Route::get('/delete/product/{id}','DeleteProduct')->name('delete.product');

        Route::get('/barcode/product/{id}','BarcodeProduct')->name('barcode.product');

        Route::get('/import/product','ImportProduct')->name('import.product');
        Route::get('/export','Export')->name('export');
        Route::post('/import','Import')->name('import');
        Route::get('/get-product-unit/{product}', [ProductController::class, 'getProductUnit']);


    });
    ///Purchase All Route
    Route::controller(PurchaseController::class)->group(function(){
        Route::get('/all/purchases','AllPurchases')->name('all.purchases');
        Route::get('/add/purchase','AddPurchase')->name('add.purchase');
        Route::post('/store/purchase','StorePurchase')->name('purchase.store');
        Route::get('/edit/purchase/{id}','EditPurchase')->name('edit.purchase');
        Route::post('/update/purchase/','UpdatePurchase')->name('purchase.update');

    });

    ///Purchase All Route
    Route::controller(FoodController::class)->group(function(){
        Route::get('/all/recipe','AllRecipe')->name('all.recipe');
        Route::get('/add/recipe','AddRecipe')->name('add.recipe');
        Route::post('/store/recipe','StoreRecipe')->name('recipe.store');
        Route::get('/edit/purchase/{id}','EditPurchase')->name('edit.purchase');
        Route::post('/update/purchase/','UpdatePurchase')->name('purchase.update');

    });


    ///Kitchen All Route
    Route::controller(KitchenController::class)->group(function(){
        Route::get('/add/order','AddOrder')->name('add.order');
        Route::get('/chef/recipe/{recipe}/ingredients', [KitchenController::class, 'checkRecipeIngredients']);
        Route::post('/chef/kitchen-order/save', [KitchenController::class, 'saveKitchenOrder']);


        Route::get('kitchen-orders/drafts', [KitchenController::class, 'viewDrafts'])->name('chef.kitchen.drafts');
        Route::get('kitchen-order/{order}/preview', [KitchenController::class, 'previewOrder'])->name('chef.kitchen.preview');
        Route::post('kitchen-order/{order}/approve', [KitchenController::class, 'approveOrder'])->name('chef.kitchen.approve');
        Route::get('kitchen-order/{order}/pdf', [KitchenController::class, 'downloadPdf'])->name('chef.kitchen.pdf');
        Route::get('/chef/meal/{meal}/ingredients', [KitchenController::class, 'mealIngredients']);


    });

    ///Department All Route
    Route::controller(DepartmentController::class)->group(function(){
        Route::get('/departments', [DepartmentController::class, 'index'])->name('departments.index');
        Route::post('/departments/store', [DepartmentController::class, 'store'])->name('departments.store');
        Route::post('/departments/update/{id}', [DepartmentController::class, 'update'])->name('departments.update');
        Route::get('/departments/delete/{id}', [DepartmentController::class, 'destroy'])->name('departments.delete');



    });
    //Designation All Route
    Route::controller(DesignationController::class)->group(function(){

        Route::get('/designations', [DesignationController::class, 'index'])->name('designations.index');
        Route::post('/designations/store', [DesignationController::class, 'store'])->name('designations.store');
        Route::post('/designations/update/{id}', [DesignationController::class, 'update'])->name('designations.update');
        Route::get('/designations/delete/{id}', [DesignationController::class, 'destroy'])->name('designations.delete');




    });
    //Meals All Route
    Route::controller(MealController::class)->group(function(){
        Route::resource('meals', MealController::class);





    });



    // Employee Loans / Advances
    Route::get('/employee-loans/create/{employee_id}', [EmployeeLoanController::class, 'create'])->name('employee.loans.create'); // add new loan/advance
    Route::post('/employee-loans/store', [EmployeeLoanController::class, 'store'])->name('employee.loans.store'); // save loan/advance

// Deduct loan from salary
    Route::post('/employee-loans/deduct/{loan_id}', [EmployeeLoanController::class, 'deduct'])->name('employee.loans.deduct');
    Route::get('/employee-loans', [EmployeeLoanController::class, 'index'])
        ->name('employee.loans.index');

    Route::post('/employee-loans/store', [EmployeeLoanController::class, 'store'])
        ->name('employee.loans.store');

    Route::post('/employee-loans/deduct/{loan}', [EmployeeLoanController::class, 'deduct'])
        ->name('employee.loans.deduct');

    //Designation All Route
    Route::controller(EmployeeController::class)->group(function(){

        Route::get('/employees', [EmployeeController::class,'index'])->name('employees.index');
        Route::post('/employees/store', [EmployeeController::class,'store'])->name('employees.store');
        Route::post('/employees/update/{id}', [EmployeeController::class,'update'])
            ->name('employees.update');
        Route::get('/employees/export', [EmployeeController::class,'export'])->name('employees.export');
        Route::post('/employees/import', [EmployeeController::class,'import'])->name('employees.import');
        Route::get('/employees/{id}/payroll', [EmployeeController::class,'editPayroll'])->name('employees.editPayroll');
        Route::post('/employees/{id}/payroll', [EmployeeController::class,'updatePayroll'])->name('employees.updatePayroll');
        // Payroll index: list employees and assign allowances/deductions
        Route::get('/payroll', [EmployeeController::class, 'payrollIndex'])->name('payroll.index');

// Assign allowances/deductions to employee (POST)
//        Route::post('/payroll/{id}/assign', [EmployeeController::class, 'assignPayroll'])->name('payroll.assign');
        Route::get(
            '/employees/{id}/assign-benefits',
            [EmployeeController::class, 'showAssignBenefits']
        )->name('employee.assign.benefits');
        Route::post(
            '/employees/{id}/assign-payroll',
            [EmployeeController::class, 'assignPayroll']
        )->name('employee.benefits.update');
    });

// Allowances
    Route::get('/allowances', [AllowanceController::class, 'index'])->name('allowances.index');
    Route::post('/allowances/store', [AllowanceController::class, 'store'])->name('allowances.store');
    Route::get('/allowances/edit/{id}', [AllowanceController::class, 'edit'])->name('allowances.edit');
    Route::put('/allowances/update/{id}', [AllowanceController::class, 'update'])->name('allowances.update');
    Route::delete('/allowances/delete/{id}', [AllowanceController::class, 'destroy'])->name('allowances.destroy');

// Deductions
    Route::get('/deductions', [DeductionController::class, 'index'])->name('deductions.index');
    Route::post('/deductions/store', [DeductionController::class, 'store'])->name('deductions.store');
    Route::get('/deductions/edit/{id}', [DeductionController::class, 'edit'])->name('deductions.edit');
    Route::put('/deductions/update/{id}', [DeductionController::class, 'update'])->name('deductions.update');
    Route::delete('/deductions/delete/{id}', [DeductionController::class, 'destroy'])->name('deductions.destroy');


    ///Report All Route
    Route::controller(ReportController::class)->group(function(){
        // 1️⃣ Show form to pick date
        Route::get('/ingredients', [ReportController::class, 'showIngredientsReportForm'])
            ->name('reports.ingredients.form');

        // 2️⃣ Show ingredient report for a date
        Route::get('/ingredients/generate', [ReportController::class, 'ingredientReport'])
            ->name('reports.ingredients.generate');

        // 3️⃣ Download ingredient report as PDF
        Route::get('/ingredients/pdf', [ReportController::class, 'ingredientReportPdf'])
            ->name('reports.ingredients.pdf');
        // Show form to pick date for recipes report
        Route::get('/recipes', [ReportController::class, 'showRecipesReportForm'])
            ->name('reports.recipes.form');

// Generate recipes report for a specific date
        Route::get('/recipes/generate', [ReportController::class, 'recipesReport'])
            ->name('reports.recipes.generate');

// Download PDF for recipes report
        Route::get('/recipes/pdf', [ReportController::class, 'recipesReportPdf'])
            ->name('reports.recipes.pdf');

    });


    Route::post('/register/store', [RegisterController::class, 'open'])
        ->name('register.store');

    Route::get('/register/open', [RegisterController::class, 'openForm'])
        ->name('register.open');
// routes/web.php
    Route::post('/register/{register}/close', [RegisterController::class, 'closeRegister'])->name('register.close');
    Route::get('/register/{register}/summary', [RegisterController::class, 'summary'])
        ->name('register.summary');
    Route::get('/registers/all', [RegisterController::class, 'allRegisters'])->name('registers.all');

// POS screen - only accessible if register is open
    Route::middleware(['auth', 'register.open'])->group(function () {
        Route::get('/pos', [PosController::class, 'index'])->name('pos.index');
    });



// AJAX route to check product stock
    Route::post('/pos/check-product', [PosController::class, 'checkProductQuantity'])
        ->name('pos.check.product');
    Route::post('/pos/complete', [PosController::class, 'completeSale'])
        ->name('pos.complete');

    Route::get('/payroll', [PayrollController::class,'index'])
        ->name('payroll.index');

    Route::post('/payroll/run', [PayrollController::class,'runPayroll'])
        ->name('payroll.run');
    // Payroll
    Route::get('/payroll', [PayrollController::class,'index'])->name('payroll.index'); // Payroll dashboard
    Route::post('/payroll/run', [PayrollController::class,'runPayroll'])->name('payroll.run'); // Run payroll

    Route::get('/payroll/{period}', [PayrollController::class, 'showMonthPayroll'])
        ->name('payroll.show');
    Route::get('/reports/payroll/monthly/export/{month}',
        [PayrollController::class, 'exportMonthlyPayroll']
    )->name('reports.payroll.monthly.export');

    Route::get('/reports/payroll/monthly',
        [PayrollController::class, 'monthly']
    )->name('reports.payroll.monthly');

// Yearly payroll report (show form and results)
//    Route::get('/payroll/yearly', [PayrollController::class, 'showYearlyPayroll'])
//        ->name('payroll.report.yearly');
    Route::get('/payroll/report/yearly', [PayrollController::class, 'yearly'])
        ->name('payroll.report.yearly');





// Payroll report PDF
    Route::get('/payroll-report/{month}', [PayrollController::class,'generatePayrollReport'])->name('payroll.report');
// Show all paid payrolls
    Route::get('/payrolls/paid', [PayrollController::class, 'showPaidPayrolls'])->name('payrolls.paid');

// Generate individual payslip
    Route::get('/payroll/{id}/payslip', [PayrollController::class, 'generatePayslip'])
        ->name('payroll.payslip');
    // Generate payroll and redirect to payslip
    Route::post('/payroll/run-and-payslip/{employee_id}', [PayrollController::class,'runAndPayslip'])->name('payroll.runAndPayslip');
    Route::get('/payroll/report/{period}', [PayrollController::class, 'monthlyReport'])
        ->name('payroll.report.monthly');

    Route::post('/payroll/draft', [PayrollController::class, 'storeDraft'])
        ->name('payroll.draft');

    Route::get('/payroll/{run}/review', [PayrollController::class, 'review'])
        ->name('backend.payroll.payroll_review');

    Route::post(
        '/backend/payroll/{run}/approve',
        [PayrollController::class, 'approvePayroll']
    )->name('backend.payroll.approve');


    Route::post('/payroll/{run}/run', [PayrollController::class, 'runPayroll'])
        ->name('payroll.run');
    Route::get('/backend/payroll/runs',
        [PayrollController::class, 'PayrollRuns']
    )->name('backend.payroll.runs');
    Route::get('/payroll/{run}/print', [PayrollController::class, 'printPdf'])
        ->name('backend.payroll.print');



}); // End User Middleware
