@extends('admin_dashboard')
@section('admin')

    <div class="content">

        <!-- Start Content-->
        <div class="container-fluid">

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box">
                        <div class="page-title-right">
                            <div class="breadcrumb m-0">
                                <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#signup-modal">
                                    Add Unit
                                </button>
                            </div>
                        </div>
                        <h4 class="page-title">All Units</h4>
                    </div>
                </div>
            </div>
            <!-- end page title -->

            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">

                            <table id="basic-datatable" class="table dt-responsive nowrap w-100">
                                <thead>
                                <tr>
                                    <th>Sl</th>
                                    <th>Unit Name</th>
                                    <th>Unit Symbol</th>
                                    <th>Action</th>
                                </tr>
                                </thead>

                                <tbody>
                                @foreach($units as $key => $item)
                                    <tr>
                                        <td>{{ $key + 1 }}</td>
                                        <td>{{ $item->unit_name }}</td>
                                        <td>{{ $item->unit_symbol }}</td>
                                        <td>
                                            <a href="{{ route('edit.units', $item->id) }}" class="btn btn-blue rounded-pill waves-effect waves-light">Edit</a>
{{--                                            <a href="{{ route('delete.units', $item->id) }}" class="btn btn-danger rounded-pill waves-effect waves-light" id="delete">Delete</a>--}}
                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>

                        </div> <!-- end card body -->
                    </div> <!-- end card -->
                </div><!-- end col -->
            </div>
            <!-- end row -->

        </div> <!-- container -->
    </div> <!-- content -->

    <!-- Signup modal content -->
    <div id="signup-modal" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">

                <div class="modal-body">

                    <form method="POST" action="{{ route('units.store') }}">
                        @csrf

                        <div class="mb-3">
                            <label class="form-label">Unit Name</label>
                            <input type="text" name="unit_name" class="form-control" required>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Unit Symbol</label>
                            <input type="text" name="unit_symbol" class="form-control" required>
                        </div>

                        <div class="mb-3 form-check">
                            <input type="checkbox" class="form-check-input" id="is_multiple" name="is_multiple">
                            <label class="form-check-label" for="is_multiple">
                                This unit is a multiple of another unit
                            </label>
                        </div>

                        <!-- Multiple fields -->
                        <div id="multiple-fields" style="display:none">

                            <div class="mb-3">
                                <label class="form-label">Multiplier</label>
                                <input type="number" step="0.0001" min="0.0001" name="multiplier" class="form-control" placeholder="Enter custom multiplier">
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Base Unit</label>
                                <select name="base_unit_id" class="form-control">
                                    <option value="">-- Select Base Unit --</option>
                                    @foreach($units as $unit)
                                        <option value="{{ $unit->id }}">{{ $unit->unit_name }}</option>
                                    @endforeach
                                </select>
                            </div>

                        </div>


                        <button class="btn btn-primary w-100">Save Unit</button>
                    </form>


                    <script>
                        document.getElementById('is_multiple').addEventListener('change', function () {
                            document.getElementById('multiple-fields').style.display =
                                this.checked ? 'block' : 'none';
                        });
                    </script>


                </div> <!-- /.modal-body -->
            </div> <!-- /.modal-content -->
        </div> <!-- /.modal-dialog -->
    </div> <!-- /.modal -->

@endsection
