@extends('admin_dashboard')
@section('admin')

    <div class="content">

        <!-- Start Content-->
        <div class="container-fluid">

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box">
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">

                                <a href="{{ route('import.product') }}" class="btn btn-info rounded-pill waves-effect waves-light">Import </a>
                                &nbsp;&nbsp;&nbsp;
                                <a href="{{ route('export') }}" class="btn btn-danger rounded-pill waves-effect waves-light">Export </a>
                                &nbsp;&nbsp;&nbsp;

                                <a href="{{ route('add.recipe') }}" class="btn btn-primary rounded-pill waves-effect waves-light">Add Recipe </a>
                            </ol>
                        </div>
                        <h4 class="page-title">All Recipe</h4>
                    </div>
                </div>
            </div>
            <!-- end page title -->

            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">

                            <table id="basic-datatable" class="table dt-responsive nowrap w-100">
                                <thead>
                                <tr>
                                    <th>Sl</th>
                                    <th>Recipe Name</th>
                                    <th>Yield Qty</th>
                                    <th>Ingredients</th>
                                    <th>Cost of Food</th>
                                    <th>Cost price Per unit</th>
                                    <th>Selling price Per unit</th>
                                </tr>
                                </thead>

                                <tbody>
                                @foreach($recipes as $key=>$item)
                                    <tr>
                                        <td>{{$key+1}}</td>
                                        <td>{{ $item->recipe_name }}</td>

                                        <td>
                                            {{ $item->yield_qty }} {{ $item->unit->unit_name }}
                                        </td>

                                        <td>
                                            <ul class="mb-0">
                                                @foreach($item->ingredients as $ingredient)
                                                    <li>
                                                        {{ $ingredient->quantity }}
                                                        {{ $ingredient->product->product_name }}
                                                        — Cost: {{ number_format($ingredient->total_cost, 2) }}
                                                    </li>
                                                @endforeach
                                            </ul>
                                        </td>
                                        <td class="text-danger fw-bold">
                                            {{ number_format($item->production_cost, 2) }}
                                        </td>

                                        <td class="text-success fw-bold">
                                            {{ number_format($item->unit_cost, 2) }}
                                        </td>
                                        <td class="text-success fw-bold">
                                            {{ number_format($item->selling_price, 2) }}
                                        </td>
                                    </tr>
                                @endforeach


                                </tbody>

                            </table>


                        </div> <!-- end card body-->
                    </div> <!-- end card -->
                </div><!-- end col-->
            </div>
            <!-- end row-->




        </div> <!-- container -->

    </div> <!-- content -->


@endsection
