@extends('admin_dashboard')
@section('admin')

    <div class="content">

        <!-- Start Content-->
        <div class="container-fluid">

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box">
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <a href="{{ route('add.purchase') }}" class="btn btn-primary rounded-pill waves-effect waves-light">Add Purchases </a>
                            </ol>
                        </div>
                        <h4 class="page-title">All Purchase</h4>
                    </div>
                </div>
            </div>
            <!-- end page title -->

            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">


                            <table id="basic-datatable" class="table dt-responsive nowrap w-100">
                                <thead>
                                <tr>
                                    <th>Sl</th>
                                    <th>Product Name</th>
                                    <th>Purchased By</th>
                                    <th>Product Unit</th>
                                    <th>Purchase Quantity</th>
                                    <th>Purchase Price</th>
                                    <th>Purchase Date</th>
                                    <th>Action</th>
                                </tr>
                                </thead>


                                <tbody>
                                @foreach($purchases as $key => $item)
                                    @php
                                        // Get the base unit conversion if exists
                                        $childConversion = $item->unit->childConversions->first(); // smallest unit
                                        if($childConversion) {
                                            $baseUnitName = $childConversion->childUnit->unit_name; // e.g., packets
                                            $quantityInBase = $item->product_qty * $childConversion->multiplier;

                                            // Calculate higher units if applicable
                                            $multiplier = $childConversion->multiplier; // how many base units in 1 parent unit
                                            if($quantityInBase >= $multiplier) {
                                                $fullParent = floor($quantityInBase / $multiplier);
                                                $remainingBase = $quantityInBase % $multiplier;
                                                $displayQty = $fullParent . ' ' . $item->unit->unit_name;
                                                if($remainingBase > 0) {
                                                    $displayQty .= ' ' . $remainingBase . ' ' . $baseUnitName;
                                                }
                                            } else {
                                                $displayQty = $quantityInBase . ' ' . $baseUnitName;
                                            }

                                        } else {
                                            // No smaller unit
                                            $baseUnitName = $item->unit->unit_name;
                                            $quantityInBase = $item->product_qty;
                                            $displayQty = $quantityInBase . ' ' . $baseUnitName;
                                        }
                                    @endphp

                                    <tr>
                                        <td>{{ $key + 1 }}</td>
                                        <td>{{ $item['product']['product_name'] }}</td>
                                        <td>{{ $item['supplier']['name'] }}</td>
                                        <td>{{ $item['unit']['unit_name'] }}</td>
                                        <td>{{ $displayQty }}</td>
                                        <td>{{ $item->buying_price }}</td>
                                        <td>{{ \Carbon\Carbon::parse($item->purchase_date)->format('d M Y') }}</td>
                                        <td>
                                            <a href="{{ route('edit.purchase',$item->id) }}" class="btn btn-blue rounded-pill waves-effect waves-light" title="Edit"><i class="fa fa-pencil" aria-hidden="true"></i></a>
                                            <a href="{{ route('delete.supplier',$item->id) }}" class="btn btn-danger rounded-pill waves-effect waves-light" id="delete" title="Delete"><i class="fa fa-trash" aria-hidden="true"></i></a>
                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>


                            </table>

                        </div> <!-- end card body-->
                    </div> <!-- end card -->
                </div><!-- end col-->
            </div>
            <!-- end row-->




        </div> <!-- container -->

    </div> <!-- content -->


@endsection

