@extends('admin_dashboard')
@section('admin')
is it here
    <div class="container-fluid">
        <h4 class="mb-4">Monthly Payroll Report</h4>

        <div class="card">
            <div class="card-body">
                <form method="GET" action="">
                    <div class="row align-items-end">
                        <div class="col-md-3">
                            <label>Select Month</label>
                            <input type="month" name="month" class="form-control" required>
                        </div>

                        <div class="col-md-2">
                            <button class="btn btn-primary w-100">
                                Generate Report
                            </button>
                        </div>
                    </div>
                </form>

                <hr>

                <p class="text-muted">
                    Select a month to view company payroll summary.
                </p>
            </div>
        </div>
        @if($payrolls->count())
            <div class="table-responsive mt-4">
                @if($month)
                    <a href="{{ route('reports.payroll.monthly.export', $month) }}"
                       class="btn btn-success mb-3">
                        Export to Excel
                    </a>
                @endif
                <table class="table table-bordered table-striped">
                    <thead class="table-dark">
                    <tr>
                        <th>#</th>
                        <th>Employee</th>
                        <th>Basic</th>
                        <th>Allowances</th>
                        <th>Gross Pay</th>
                        <th>Loan Deductions</th>
                        <th>Other Deductions</th>
                        <th>Total Deductions</th>
                        <th>Net Pay</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($payrolls as $key => $payroll)
                        <tr>
                            <td>{{ $key + 1 }}</td>

                            <td>{{ $payroll->employee->full_name ?? 'N/A' }}</td>

                            <td>{{ number_format($payroll->basic_salary, 2) }}</td>

                            {{-- Allowances --}}
                            <td>
                                {{ number_format($payroll->total_allowances, 2) }}
                            </td>

                            {{-- Gross --}}
                            <td>
                                <strong>{{ number_format($payroll->gross_pay, 2) }}</strong>
                            </td>

                            {{-- Loan deductions --}}
                            <td class="text-danger">
                                {{ number_format($payroll->loan_deductions, 2) }}
                            </td>

                            {{-- Other deductions --}}
                            <td class="text-danger">
                                {{ number_format($payroll->total_deductions, 2) }}
                            </td>

                            {{-- Total deductions --}}
                            <td class="text-danger fw-bold">
                                {{ number_format(
                                    $payroll->loan_deductions + $payroll->total_deductions,
                                    2
                                ) }}
                            </td>

                            {{-- Net Pay --}}
                            <td class="text-success fw-bold">
                                {{ number_format($payroll->net_pay, 2) }}
                            </td>
                        </tr>
                    @endforeach
                    </tbody>



                    <tfoot class="table-secondary">
                    <tr>
                        <th colspan="4">TOTAL</th>
                        <th>{{ number_format($summary['gross'], 2) }}</th>
                        <th colspan="2"></th>
                        <th>{{ number_format($summary['deductions'], 2) }}</th>
                        <th>{{ number_format($summary['net'], 2) }}</th>
                    </tr>
                    </tfoot>
                </table>
            </div>
        @endif

    </div>

@endsection
