@extends('admin_dashboard')
@section('admin')

    <div class="container-fluid">
        @php
            $months = [
                1 => 'January', 2 => 'February', 3 => 'March', 4 => 'April',
                5 => 'May', 6 => 'June', 7 => 'July', 8 => 'August',
                9 => 'September', 10 => 'October', 11 => 'November', 12 => 'December'
            ];
        @endphp

        <h3>Payroll Report - {{ $months[$month] ?? $month }}</h3>

        <table class="table table-bordered table-striped">
            <thead class="table-dark">
            <tr>
                <th>#</th>
                <th>Employee</th>
                <th>Basic Salary</th>
                <th>Total Allowances</th>
                <th>Total Deductions</th>
                <th>Loan Deductions</th>
                <th>Net Pay</th>
                <th>Payslip</th>
            </tr>
            </thead>
            <tbody>
            @forelse($payrolls as $key => $pay)
                <tr>
                    <td>{{ $key + 1 }}</td>
                    <td>{{ $pay->employee ? $pay->employee->full_name : 'N/A' }}</td>
                    <td>{{ number_format($pay->basic_salary ?? 0,2) }}</td>
                    <td>{{ number_format($pay->total_allowances ?? 0,2) }}</td>
                    <td>{{ number_format($pay->total_deductions ?? 0,2) }}</td>
                    <td>
                        @php $totalLoanDeduction = $pay->total_loan_deductions ?? 0; @endphp
                        @if($pay->employee && $pay->employee->loans->count())
                            @foreach($pay->employee->loans as $loan)
                                @foreach($loan->deductions as $deduction)
                                    <small>{{ $deduction->deduction_date }} : {{ number_format($deduction->amount,2) }}</small><br>
                                @endforeach
                            @endforeach
                        @endif
                        <strong>Total: {{ number_format($totalLoanDeduction,2) }}</strong>
                    </td>
                    <td>{{ number_format($pay->net_pay ?? 0,2) }}</td>
                    <td>
                        @if($pay->employee)
                            <a href="{{ route('payroll.payslip', $pay->id) }}" class="btn btn-sm btn-primary" target="_blank">Payslip</a>
                        @else
                            N/A
                        @endif
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="8" class="text-center">No payrolls found for this month.</td>
                </tr>
            @endforelse
            </tbody>
        </table>
    </div>

@endsection
