@extends('admin_dashboard')
@section('admin')

    <h4>Create Payroll (Draft)</h4>

    {{-- Validation Errors --}}
    @if ($errors->any())
        <div class="alert alert-danger">
            {{ $errors->first() }}
        </div>
    @endif

    <form method="POST" action="{{ route('payroll.draft') }}">
        @csrf

        {{-- Payroll Month --}}
        <div class="mb-3">
            <label class="form-label">Payroll Month</label>
            <input type="month" name="month" class="form-control" required>
        </div>

        <h5>Select Eligible Employees</h5>

        {{-- Select All --}}
        <div class="form-check mb-2">
            <input
                type="checkbox"
                id="selectAll"
                class="form-check-input"
            >
            <label for="selectAll" class="form-check-label">
                <strong>Select All Employees</strong>
            </label>
        </div>

        <hr>

        {{-- Employees --}}
        @foreach($employees as $employee)
            <div class="form-check">
                <input
                    class="form-check-input employee-checkbox"
                    type="checkbox"
                    name="employees[]"
                    value="{{ $employee->id }}"
                    id="emp{{ $employee->id }}"
                >
                <label class="form-check-label" for="emp{{ $employee->id }}">
                    {{ $employee->full_name }}
                </label>
            </div>
        @endforeach

        <button class="btn btn-primary mt-3">
            Save Draft
        </button>

    </form>

    {{-- Select All Script --}}
    <script>
        const selectAll = document.getElementById('selectAll');
        const employeeCheckboxes = document.querySelectorAll('.employee-checkbox');

        // 1️⃣ Click "Select All"
        selectAll.addEventListener('change', function () {
            employeeCheckboxes.forEach(cb => {
                cb.checked = this.checked;
            });
        });

        // 2️⃣ Individual employee checkbox change
        employeeCheckboxes.forEach(cb => {
            cb.addEventListener('change', function () {
                // If all are checked → Select All checked, else unchecked
                const allChecked = Array.from(employeeCheckboxes).every(el => el.checked);
                selectAll.checked = allChecked;
            });
        });
    </script>


@endsection
