@extends('admin_dashboard')
@section('admin')

    <div class="container-fluid">
        <h4>Payroll for {{ \Carbon\Carbon::parse($month.'-01')->format('F Y') }}</h4>

        <div class="mb-3">
            <a href="{{ route('payroll.report', $month) }}" class="btn btn-primary">Download Payroll Report PDF</a>
        </div>

        <div class="card">
            <div class="card-body table-responsive">
                <table class="table table-bordered">
                    <thead class="table-dark">
                    <tr>
                        <th>#</th>
                        <th>Employee</th>
                        <th>Basic Salary</th>
                        <th>Total Allowances</th>
                        <th>Total Deductions</th>
                        <th>Loan Deductions</th>
                        <th>Net Pay</th>
                        <th>Action</th>
                    </tr>
                    </thead>
                    <tbody>
                    @forelse($payrolls as $pay)
                        <tr>
                            <td>{{ $loop->iteration }}</td>
                            <td>{{ $pay->employee->full_name }}</td>
                            <td>{{ number_format($pay->basic_salary,2) }}</td>
                            <td>{{ number_format($pay->total_allowances,2) }}</td>
                            <td>{{ number_format($pay->total_deductions,2) }}</td>
                            <td>{{ number_format($pay->loan_deductions,2) }}</td>
                            <td>{{ number_format($pay->net_pay,2) }}</td>
                            <td>
                                <a href="{{ route('payroll.payslip',$pay->id) }}" class="btn btn-sm btn-primary">Payslip PDF</a>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="8" class="text-center">No payroll processed for this month</td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>

@endsection
