<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Payslip - {{ $payroll->employee->full_name ?? 'Employee' }}</title>
    <style>
        @page {
            size: 105mm 148mm;
            margin: 0;
        }

        body {
            font-family: 'Courier New', Courier, monospace; /* Monospace looks more authentic for these slips */
            font-size: 10px;
            margin: 0;
            padding: 5mm;
            color: #333;
        }

        .payslip-container {
            width: 100%;
            border: 1.5px dotted #666;
            padding: 8px;
            box-sizing: border-box;
            position: relative;
            background-color: #fff;
        }

        /* LOGO PLACEHOLDERS */
        .hris-logo-placeholder {
            position: absolute;
            top: 5px;
            right: 8px;
            width: 35px;
            height: 35px;
            border: 1px solid #ddd;
            text-align: center;
            font-size: 7px;
            background: #fff;
        }

        .watermark-placeholder {
            position: absolute;
            top: 45%;
            left: 50%;
            transform: translate(-50%, -50%);
            width: 120px;
            height: 120px;
            border: 1px dashed #eee;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #f0f0f0;
            font-weight: bold;
            font-size: 10px;
            z-index: 0;
            pointer-events: none;
        }

        .header-section {
            text-align: center;
            margin-bottom: 5px;
            z-index: 1;
            position: relative;
        }

        .payslip-date {
            color: #d12027;
            font-weight: bold;
            font-style: italic;
        }

        .employee-details {
            width: 100%;
            margin: 8px 0;
            border-collapse: collapse;
            z-index: 1;
            position: relative;
        }

        .bank-name {
            text-align: center;
            color: #000080;
            font-weight: bold;
            text-transform: uppercase;
            margin: 5px 0;
        }

        .data-table {
            width: 100%;
            border-collapse: collapse;
            z-index: 1;
            position: relative;
        }

        .text-right { text-align: right; }
        .bold { font-weight: bold; }

        .total-row td {
            border-top: 1px solid #000;
            padding: 4px 0;
            font-weight: bold;
        }
    </style>
</head>
<body>

<div class="payslip-container">
    <div class="hris-logo-placeholder">LOGO<br>LOGO</div>
    <div class="watermark-placeholder">Company Logo</div>

    <div class="header-section">
        <div class="bold">Company - Executive</div>
        <div class="payslip-date">Pay-Slip({{ date('F-Y', strtotime($payroll->pay_period)) }})</div>
        <small style="font-size: 7px; color: #999;">V1.0.Build.{{ time() }}</small>
    </div>

    <table class="employee-details">
        <tr>
            <td style="width: 45%;">PF-Num: {{ $payroll->employee->payroll_no ?? 'N/A' }}</td>
            <td class="bold">{{ $payroll->employee->full_name }}</td>
        </tr>
        @if($payroll->employee->station)
            <tr>
                <td>Station: {{ $payroll->employee->station }}</td>
                <td></td>
            </tr>
        @endif
        <tr>
            <td>{{ $payroll->employee->job_code ?? '' }}</td>
            @if($payroll->employee->incr_month) <td>Incr: {{ $payroll->employee->incr_month }}</td> @endif
            @if($payroll->employee->rod) <td>RoD: {{ $payroll->employee->rod }}</td> @endif
        </tr>
        @if($payroll->employee->designation)
            <tr>
                <td colspan="3">Desig: {{ $payroll->employee->designation->name }}</td>
            </tr>
        @endif
        <tr>
            <td>ID-Num: {{ $payroll->employee->id_number ?? '---' }}</td>
            <td>Tax-PIN: {{ $payroll->employee->tax_pin ?? '---' }}</td>
            <td>@if($payroll->employee->age) {{ $payroll->employee->age }} yrs @endif (P&P)</td>
        </tr>
    </table>

    <div class="bank-name">
        {{ $payroll->employee->bank_name ?? 'CASH PAYMENT' }}
    </div>

    <table class="data-table">
        <tr>
            <td>Basic Salary</td>
            <td class="text-right">{{ number_format($payroll->basic_salary, 2) }}</td>
        </tr>
        @isset($payroll->allowances)
            @foreach($payroll->allowances as $allowance)
                <tr>
                    <td>{{ $allowance->name }}</td>
                    <td class="text-right">{{ number_format($allowance->amount, 2) }}</td>
                </tr>
            @endforeach
        @endisset

        <tr class="bold">
            <td>TOTAL Earnings</td>
            <td class="text-right">{{ number_format($payroll->gross_pay, 2) }}</td>
        </tr>

        @isset($loanDeductions)
            @foreach($loanDeductions as $loan)
                <tr>
                    <td>{{ $loan->name }} @if($loan->balance) ({{ number_format($loan->balance, 2) }}) @endif</td>
                    <td class="text-right">-{{ number_format($loan->amount, 2) }}</td>
                </tr>
            @endforeach
        @endisset

        @isset($otherDeductions)
            @foreach($otherDeductions as $deduction)
                <tr>
                    <td>{{ $deduction->name }}</td>
                    <td class="text-right">-{{ number_format($deduction->amount, 2) }}</td>
                </tr>
            @endforeach
        @endisset

        @if(($payroll->paye ?? 0) > 0)
            <tr>
                <td>PAYE Auto</td>
                <td class="text-right">-{{ number_format($payroll->paye, 2) }}</td>
            </tr>
        @endif
        @if(($payroll->shif ?? 0) > 0)
            <tr>
                <td>SHIF Auto</td>
                <td class="text-right">-{{ number_format($payroll->shif, 2) }}</td>
            </tr>
        @endif
        @if(($payroll->housing_levy ?? 0) > 0)
            <tr>
                <td>Housing Levy Fund</td>
                <td class="text-right">-{{ number_format($payroll->housing_levy, 2) }}</td>
            </tr>
        @endif

        <tr class="total-row">
            <td>NET PAY</td>
            <td class="text-right">{{ number_format($netPay, 2) }}</td>
        </tr>
    </table>
</div>

</body>
</html>
