@extends('admin_dashboard')
@section('admin')

    <div class="content">
        <div class="card">
            <div class="card-body">
                <h5>Meals List</h5>

                <a href="{{ route('meals.create') }}" class="btn btn-primary mb-3">Add New Meal</a>

                <table id="basic-datatable" class="table dt-responsive nowrap w-100">
                    <thead>
                    <tr>
                        <th>#</th>
                        <th>Meal Name</th>
                        <th>Recipes Included</th>
                        <th>Actions</th>
                    </tr>
                    </thead>
                    <tbody>
                    @forelse($meals as $index => $meal)
                        <tr>
                            <td>{{ $index + 1 }}</td>
                            <td>{{ $meal->meal_name }}</td>
                            <td>
                                <ul>
                                    @foreach($meal->recipes as $recipe)
                                        <li>{{ $recipe->recipe_name }} (Qty: {{ $recipe->pivot->quantity }})</li>
                                    @endforeach
                                </ul>
                            </td>
                            <td>
                                <a href="{{ route('meals.edit', $meal->id) }}" class="btn btn-sm btn-warning">Edit</a>
                                <form action="{{ route('meals.destroy', $meal->id) }}" method="POST" style="display:inline-block;">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">Delete</button>
                                </form>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="4" class="text-center">No meals created yet.</td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>

            </div>
        </div>
    </div>

@endsection
