@extends('admin_dashboard')
@section('admin')

    <div class="content">
        <div class="card">
            <div class="card-body">
                <h5>Create Meal</h5>

                <form action="{{ route('meals.store') }}" method="POST">
                    @csrf

                    <div class="mb-3">
                        <label>Meal Name</label>
                        <input type="text" name="meal_name" class="form-control" required>
                    </div>

                    <h6>Select Recipes for this Meal</h6>

                    <div class="row mb-2">
                        <div class="col-md-6">
                            <select id="recipeSelect" class="form-select">
                                <option value="">Select Recipe</option>
                                @foreach($recipes as $recipe)
                                    <option value="{{ $recipe->id }}" data-name="{{ $recipe->recipe_name }}">
                                        {{ $recipe->recipe_name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-3">
                            <input type="number" id="recipeQty" class="form-control" placeholder="Qty" min="1" value="1">
                        </div>
                        <div class="col-md-3">
                            <button type="button" id="addRecipeBtn" class="btn btn-primary">Add Recipe</button>
                        </div>
                    </div>

                    <table class="table table-bordered" id="mealRecipesTable">
                        <thead>
                        <tr>
                            <th>Recipe</th>
                            <th>Quantity</th>
                            <th>Action</th>
                        </tr>
                        </thead>
                        <tbody>
                        <!-- Recipes will be added here dynamically -->
                        </tbody>
                    </table>

                    <button type="submit" class="btn btn-success mt-2">Save Meal</button>
                </form>
            </div>
        </div>
    </div>

    <script>
        let addedRecipes = {};

        document.getElementById('addRecipeBtn').addEventListener('click', () => {
            const select = document.getElementById('recipeSelect');
            const recipeId = select.value;
            const recipeName = select.options[select.selectedIndex].dataset.name;
            const qty = parseFloat(document.getElementById('recipeQty').value);

            if (!recipeId || qty <= 0) return alert('Select a recipe and enter valid quantity');

            if (addedRecipes[recipeId]) return alert('This recipe is already added!');

            addedRecipes[recipeId] = qty;

            const tbody = document.querySelector('#mealRecipesTable tbody');
            const row = document.createElement('tr');

            row.innerHTML = `
            <td>${recipeName}</td>
            <td>
                <input type="number" name="recipes[${recipeId}]" class="form-control" value="${qty}" min="1">
            </td>
            <td>
                <button type="button" class="btn btn-danger btn-sm removeBtn">Remove</button>
            </td>
        `;

            row.querySelector('.removeBtn').addEventListener('click', () => {
                delete addedRecipes[recipeId];
                row.remove();
            });

            tbody.appendChild(row);
        });
    </script>

@endsection
