@extends('admin_dashboard')
@section('admin')
    <div class="container-fluid">

        <div class="d-flex justify-content-between align-items-center mb-3">
            <h4>Employees</h4>

            <div>
                <a href="{{ route('employees.export') }}" class="btn btn-success btn-sm">
                    Export Excel
                </a>

                <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#importEmployees">
                    Import Excel
                </button>
            </div>
        </div>

        {{-- Success Message --}}
        @if(session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif

        {{-- ADD EMPLOYEE --}}
        <div class="card mb-4">
            <div class="card-header">
                <strong>Add Employee</strong>
            </div>
            <div class="card-body">
                <form method="POST" action="{{ route('employees.store') }}">
                    @csrf

                    <div class="row">

                        <div class="col-md-4 mb-3">
                            <label>Full Name</label>
                            <input type="text" name="full_name" class="form-control" required>
                        </div>

                        <div class="col-md-4 mb-3">
                            <label>Gender</label>
                            <select name="gender" class="form-control" required>
                                <option value="">Select Gender</option>
                                <option value="Male">Male</option>
                                <option value="Female">Female</option>
                            </select>
                        </div>

                        <div class="col-md-4 mb-3">
                            <label>Department</label>
                            <select name="department_id" class="form-control" required>
                                <option value="">Select Department</option>
                                @foreach($departments as $department)
                                    <option value="{{ $department->id }}">{{ $department->name }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-md-4 mb-3">
                            <label>Designation</label>
                            <select name="designation_id" class="form-control" required>
                                <option value="">Select Designation</option>
                                @foreach($designations as $designation)
                                    <option value="{{ $designation->id }}">{{ $designation->name }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-md-4 mb-3">
                            <label>Basic Salary</label>
                            <input type="number" name="basic_salary" class="form-control" required>
                        </div>

                        <div class="col-md-4 mb-3">
                            <label>Hire Date</label>
                            <input type="date" name="hire_date" class="form-control" required>
                        </div>

                        <div class="col-md-4 d-flex align-items-end mb-3">
                            <button class="btn btn-success w-100">
                                Save Employee
                            </button>
                        </div>

                    </div>
                </form>
            </div>
        </div>

        {{-- EMPLOYEE LIST --}}
        <div class="card">
            <div class="card-header">
                <strong>Employee List</strong>
            </div>
            <div class="card-body">
                <table id="basic-datatable" class="table dt-responsive nowrap w-100">
                    <thead>
                    <tr>
                        <th>Code</th>
                        <th>Name</th>
                        <th>Gender</th>
                        <th>Department</th>
                        <th>Designation</th>
                        <th>Salary</th>
                        <th>Status</th>
                        <th width="100">Action</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($employees as $employee)
                        <tr>
                            <td>{{ $employee->employee_code }}</td>
                            <td>{{ $employee->full_name }}</td>
                            <td>{{ $employee->gender }}</td>
                            <td>{{ $employee->department->name }}</td>
                            <td>{{ $employee->designation->name }}</td>
                            <td>{{ number_format($employee->basic_salary, 2) }}</td>
                            <td>
                            <span class="badge bg-{{ $employee->status ? 'success' : 'danger' }}">
                                {{ $employee->status ? 'Active' : 'Inactive' }}
                            </span>
                            </td>
                            <td>
                                <button class="btn btn-sm btn-info"
                                        data-bs-toggle="modal"
                                        data-bs-target="#editEmployee{{ $employee->id }}">
                                    Edit
                                </button>
                            <td> <a href="{{ route('employee.assign.benefits', $employee->id) }}"
                                    class="btn btn-sm btn-primary">
                                    Assign Allowances & Deductions
                                </a></td>
                            </td>
                        </tr>

                        {{-- EDIT MODAL --}}
                        <div class="modal fade" id="editEmployee{{ $employee->id }}">
                            <div class="modal-dialog modal-lg">
                                <form method="POST" action="{{ route('employees.update', $employee->id) }}">
                                    @csrf
                                    <div class="modal-content">

                                        <div class="modal-header">
                                            <h5>Edit Employee</h5>
                                            <button class="btn-close" data-bs-dismiss="modal"></button>
                                        </div>

                                        <div class="modal-body">
                                            <div class="row">

                                                <div class="col-md-6 mb-3">
                                                    <label>Employee Code</label>
                                                    <input class="form-control" value="{{ $employee->employee_code }}" disabled>
                                                </div>

                                                <div class="col-md-6 mb-3">
                                                    <label>Full Name</label>
                                                    <input name="full_name" class="form-control" value="{{ $employee->full_name }}" required>
                                                </div>

                                                <div class="col-md-6 mb-3">
                                                    <label>Gender</label>
                                                    <select name="gender" class="form-control" required>
                                                        <option value="Male" {{ $employee->gender=='Male'?'selected':'' }}>Male</option>
                                                        <option value="Female" {{ $employee->gender=='Female'?'selected':'' }}>Female</option>
                                                        <option value="Other" {{ $employee->gender=='Other'?'selected':'' }}>Other</option>
                                                    </select>
                                                </div>

                                                <div class="col-md-6 mb-3">
                                                    <label>Department</label>
                                                    <select name="department_id" class="form-control">
                                                        @foreach($departments as $department)
                                                            <option value="{{ $department->id }}"
                                                                {{ $department->id == $employee->department_id ? 'selected':'' }}>
                                                                {{ $department->name }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </div>

                                                <div class="col-md-6 mb-3">
                                                    <label>Designation</label>
                                                    <select name="designation_id" class="form-control">
                                                        @foreach($designations as $designation)
                                                            <option value="{{ $designation->id }}"
                                                                {{ $designation->id == $employee->designation_id ? 'selected':'' }}>
                                                                {{ $designation->name }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </div>

                                                <div class="col-md-6 mb-3">
                                                    <label>Basic Salary</label>
                                                    <input type="number" name="basic_salary" class="form-control"
                                                           value="{{ $employee->basic_salary }}" required>
                                                </div>

                                                <div class="col-md-6 mb-3">
                                                    <label>Hire Date</label>
                                                    <input type="date" name="hire_date" class="form-control"
                                                           value="{{ $employee->hire_date }}" required>
                                                </div>

                                                <div class="col-md-6 mb-3">
                                                    <label>Status</label>
                                                    <select name="status" class="form-control">
                                                        <option value="1" {{ $employee->status ? 'selected':'' }}>Active</option>
                                                        <option value="0" {{ !$employee->status ? 'selected':'' }}>Inactive</option>
                                                    </select>
                                                </div>

                                            </div>
                                        </div>

                                        <div class="modal-footer">
                                            <button class="btn btn-primary">Update Employee</button>
                                        </div>

                                    </div>
                                </form>
                            </div>
                        </div>
                        {{-- END MODAL --}}

                    @endforeach
                    </tbody>
                </table>
            </div>
        </div>

    </div>

    {{-- IMPORT MODAL --}}
    <div class="modal fade" id="importEmployees">
        <div class="modal-dialog">
            <form method="POST" action="{{ route('employees.import') }}" enctype="multipart/form-data">
                @csrf
                <div class="modal-content">
                    <div class="modal-header">
                        <h5>Import Employees (Excel)</h5>
                        <button class="btn-close" data-bs-dismiss="modal"></button>
                    </div>

                    <div class="modal-body">
                        <input type="file" name="file" class="form-control" required>
                    </div>

                    <div class="modal-footer">
                        <button class="btn btn-success">Import</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
