@extends('admin_dashboard')
@section('admin')
    <div class="container-fluid">

        <h4 class="mb-3">Payroll Settings: {{ $employee->full_name }}</h4>

        @if(session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif

        <form action="{{ route('employees.updatePayroll', $employee->id) }}" method="POST">
            @csrf

            <div class="row">

                {{-- Allowances --}}
                <div class="col-md-6">
                    <div class="card mb-3">
                        <div class="card-header bg-success text-white">Allowances</div>
                        <div class="card-body">
                            @foreach($allowances as $allowance)
                                <div class="form-check">
                                    <input type="checkbox" name="allowances[]" value="{{ $allowance->id }}"
                                           class="form-check-input"
                                        {{ $employee->allowances->contains($allowance->id) ? 'checked' : '' }}>
                                    <label class="form-check-label">{{ $allowance->name }}
                                        ({{ ucfirst($allowance->type) }}: {{ $allowance->amount }})
                                    </label>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>

                {{-- Deductions --}}
                <div class="col-md-6">
                    <div class="card mb-3">
                        <div class="card-header bg-danger text-white">Deductions</div>
                        <div class="card-body">
                            @foreach($deductions as $deduction)
                                <div class="form-check">
                                    <input type="checkbox" name="deductions[]" value="{{ $deduction->id }}"
                                           class="form-check-input"
                                        {{ $employee->deductions->contains($deduction->id) ? 'checked' : '' }}>
                                    <label class="form-check-label">{{ $deduction->name }}
                                        ({{ ucfirst($deduction->type) }}: {{ $deduction->amount }})
                                    </label>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>

            </div>

            <div class="mt-3">
                <button class="btn btn-primary">Save Payroll Settings</button>
            </div>

        </form>
    </div>
@endsection
