@extends('admin_dashboard')
@section('admin')

    <div class="container-fluid">
        <h4>Employee Loans & Advances</h4>

        @if(session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif

        {{-- ADD LOAN / ADVANCE --}}
        <div class="card mb-4">
            <div class="card-body">
                <form method="POST" action="{{ route('employee.loans.store') }}">
                    @csrf
                    <div class="row align-items-end">
                        <div class="col-md-4">
                            <label>Employee</label>
                            <select name="employee_id" class="form-control" required>
                                <option value="">Select Employee</option>
                                @foreach($employees as $employee)
                                    <option value="{{ $employee->id }}">
                                        {{ $employee->full_name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-md-3">
                            <label>Type</label>
                            <select name="type" class="form-control" required>
                                <option value="loan">Loan</option>
                                <option value="advance">Advance Salary</option>
                            </select>
                        </div>

                        <div class="col-md-3">
                            <label>Amount</label>
                            <input type="number" name="amount" class="form-control" required>
                        </div>

                        <div class="col-md-2">
                            <button class="btn btn-primary w-100">Add</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        {{-- LOANS TABLE --}}
        <div class="card">
            <div class="card-body table-responsive">
                <table class="table table-bordered w-100">
                    <thead class="table-dark">
                    <tr>
                        <th>#</th>
                        <th>Employee</th>
                        <th>Type</th>
                        <th>Total</th>
                        <th>Remaining</th>
                        <th>Deduction History</th>
                        <th>Deduct</th>
                    </tr>
                    </thead>
                    <tbody>
                    @forelse($loans as $key => $loan)
                        <tr>
                            <td>{{ $key+1 }}</td>
                            <td>{{ $loan->employee->full_name }}</td>
                            <td>{{ ucfirst($loan->type) }}</td>
                            <td>{{ number_format($loan->amount,2) }}</td>
                            <td>{{ number_format($loan->remaining_amount,2) }}</td>
                            <td>
                                @foreach($loan->deductions as $d)
                                    <small>
                                        {{ $d->deduction_date }} - {{ number_format($d->amount,2) }}
                                    </small><br>
                                @endforeach
                            </td>
                            <td>
                                @if($loan->remaining_amount > 0)
                                    <form method="POST" action="{{ route('employee.loans.deduct',$loan->id) }}">
                                        @csrf
                                        <input type="number"
                                               name="amount"
                                               class="form-control mb-1"
                                               max="{{ $loan->remaining_amount }}"
                                               placeholder="Amount">
                                        <button class="btn btn-success btn-sm w-100">
                                            Deduct
                                        </button>
                                    </form>
                                @else
                                    <span class="badge bg-success">Cleared</span>
                                @endif
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="text-center">
                                No loans or advances recorded
                            </td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>

@endsection
