@extends('admin_dashboard')
@section('admin')
    <div class="container-fluid">

        <div class="d-flex justify-content-between mb-3">
            <h4>Designations</h4>
            <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addDesignation">
                + Add Designation
            </button>
        </div>

        @if(session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif

        <div class="card">
            <div class="card-body">
                <table id="basic-datatable" class="table dt-responsive nowrap w-100">
                    <thead>
                    <tr>
                        <th>#</th>
                        <th>Designation</th>
                        <th>Department</th>
                        <th>Status</th>
                        <th width="150">Action</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($designations as $key => $designation)
                        <tr>
                            <td>{{ $key + 1 }}</td>
                            <td>{{ $designation->name }}</td>
                            <td>{{ $designation->department->name }}</td>
                            <td>
                            <span class="badge bg-{{ $designation->status ? 'success' : 'danger' }}">
                                {{ $designation->status ? 'Active' : 'Inactive' }}
                            </span>
                            </td>
                            <td>
                                <button class="btn btn-sm btn-info"
                                        data-bs-toggle="modal"
                                        data-bs-target="#edit{{ $designation->id }}">
                                    Edit
                                </button>

                                <a href="{{ route('designations.delete',$designation->id) }}"
                                   onclick="return confirm('Delete this designation?')"
                                   class="btn btn-sm btn-danger">
                                    Delete
                                </a>
                            </td>
                        </tr>

                        {{-- Edit Modal --}}
                        <div class="modal fade" id="edit{{ $designation->id }}">
                            <div class="modal-dialog">
                                <form method="POST" action="{{ route('designations.update',$designation->id) }}">
                                    @csrf
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5>Edit Designation</h5>
                                            <button class="btn-close" data-bs-dismiss="modal"></button>
                                        </div>
                                        <div class="modal-body">
                                            <select name="department_id" class="form-control mb-2">
                                                @foreach($departments as $dept)
                                                    <option value="{{ $dept->id }}"
                                                        {{ $dept->id == $designation->department_id ? 'selected' : '' }}>
                                                        {{ $dept->name }}
                                                    </option>
                                                @endforeach
                                            </select>

                                            <input type="text" name="name"
                                                   value="{{ $designation->name }}"
                                                   class="form-control mb-2" required>
                                        </div>
                                        <div class="modal-footer">
                                            <button class="btn btn-primary">Update</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>

                    @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    {{-- Add Modal --}}
    <div class="modal fade" id="addDesignation">
        <div class="modal-dialog">
            <form method="POST" action="{{ route('designations.store') }}">
                @csrf
                <div class="modal-content">
                    <div class="modal-header">
                        <h5>Add Designation</h5>
                        <button class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <select name="department_id" class="form-control mb-2" required>
                            <option value="">Select Department</option>
                            @foreach($departments as $dept)
                                <option value="{{ $dept->id }}">{{ $dept->name }}</option>
                            @endforeach
                        </select>

                        <input type="text" name="name" class="form-control" placeholder="Designation name" required>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-success">Save</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

@endsection
