@extends('admin_dashboard')
@section('admin')
    <div class="container-fluid">

        <h4>Deductions</h4>

        @if(session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif

        {{-- Add Allowance --}}
        <div class="card mb-3">
            <div class="card-body">
                <form action="{{ route('deductions.store') }}" method="POST">
                    @csrf
                    <div class="row align-items-end">
                        <div class="col-md-4">
                            <label>Name</label>
                            <input type="text" name="name" class="form-control" required>
                        </div>
                        <div class="col-md-3">
                            <label>Type</label>
                            <select name="type" class="form-control" required>
                                <option value="fixed">Fixed</option>
                                <option value="percentage">Percentage</option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label>Amount</label>
                            <input type="number" name="amount" class="form-control" required>
                        </div>
                        <div class="col-md-2">
                            <button class="btn btn-success w-100">Add</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        {{-- Allowances Table --}}
        <div class="card">
            <div class="card-body table-responsive">
                <table id="basic-datatable" class="table dt-responsive nowrap w-100">
                    <thead class="table-dark">
                    <tr>
                        <th>#</th>
                        <th>Name</th>
                        <th>Type</th>
                        <th>Amount</th>
                        <th>Action</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($deductions as $key => $deduction)
                        <tr>
                            <td>{{ $key+1 }}</td>
                            <td>{{ $deduction->name }}</td>
                            <td>{{ ucfirst($deduction->type) }}</td>
                            <td>{{ $deduction->amount }}</td>
                            <td>
                                <a href="{{ route('deductions.edit',$deduction->id) }}" class="btn btn-warning btn-sm">Edit</a>
                                <form action="{{ route('deductions.destroy',$deduction->id) }}" method="POST" class="d-inline">
                                    @csrf @method('DELETE')
                                    <button class="btn btn-danger btn-sm" onclick="return confirm('Delete?')">Delete</button>
                                </form>
                            </td>
                        </tr>
                    @endforeach

                    </tbody>
                </table>
            </div>
        </div>

    </div>
@endsection
