<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payrolls', function (Blueprint $table) {
            $table->id();
            $table->date('pay_period'); // e.g 2026-01-01
            $table->decimal('basic_salary',12,2);
            $table->decimal('total_allowances',12,2)->default(0);
            $table->decimal('total_deductions',12,2)->default(0);
            $table->decimal('loan_deductions',12,2)->default(0);
            $table->decimal('gross_pay',12,2);
            $table->decimal('net_pay',12,2);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payrolls');
    }
};
