<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('kitchen_order_approvals', function (Blueprint $table) {
            $table->id();
            Schema::create('kitchen_order_approvals', function (Blueprint $table) {
                $table->id();

                // Link to the kitchen order
                $table->foreignId('kitchen_order_id')->constrained('kitchen_orders')->onDelete('cascade');

                // Who approved it
                $table->foreignId('user_id')->constrained('users')->onDelete('cascade');

                // Recipe details
                $table->foreignId('recipe_id')->constrained('recipes')->onDelete('cascade');
                $table->string('recipe_name');
                $table->decimal('approved_qty', 10, 3); // how much chef approved
                $table->decimal('unit_cost', 10, 2);
                $table->decimal('total_cost', 12, 2);

                // Optional: include any additional useful info
                $table->date('order_date');             // same as kitchen order
                $table->text('remarks')->nullable();    // optional chef notes
                $table->json('ingredient_details');     // store ingredient breakdown (optional, useful for audit)

                $table->timestamps();
            });
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('kitchen_order_approvals');
    }
};
