<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('register_closure_items', function (Blueprint $table) {
            $table->id();

            $table->foreignId('register_closure_id')
                ->constrained()
                ->cascadeOnDelete();

            $table->foreignId('recipe_id')
                ->nullable()
                ->constrained()
                ->nullOnDelete();

            $table->string('recipe_name');

            // Kitchen vs POS movement
            $table->integer('approved_qty');   // from kitchen orders
            $table->integer('sold_qty');       // from POS
            $table->integer('remaining_qty');  // approved - sold

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('register_closure_items');
    }
};
