<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('unit_conversations', function (Blueprint $table) {
            $table->id();

            $table->foreignId('parent_unit_id')
                ->constrained('units')
                ->cascadeOnDelete();

            $table->foreignId('child_unit_id')
                ->constrained('units')
                ->cascadeOnDelete();

            $table->decimal('multiplier', 10, 4); // 12, 1000, etc

            $table->timestamps();

            $table->unique(['parent_unit_id', 'child_unit_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('unit_conversations');
    }
};
