<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;


class Unit extends Model
{
    protected $guarded = [];

    // Units that this unit can convert **to smaller units**
    public function parentConversions()
    {
        return $this->hasMany(Unit_conversation::class, 'parent_unit_id');
    }

    // Units that this unit can convert **from larger units**
    public function childConversions()
    {
        return $this->hasMany(Unit_conversation::class, 'parent_unit_id'); // parent -> child
    }
}
