<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Register extends Model
{
    //
    protected $guarded = [];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    protected $casts = [
        'opened_at' => 'datetime',
        'closed_at' => 'datetime',
    ];
    public function sales()
    {
        return $this->hasMany(Sale::class);
    }

    // Kitchen approvals linked to this register
    public function kitchenApprovals()
    {
        return $this->hasMany(Kitchen_order_approval::class);
    }

    // Kitchen ingredients linked to this register (optional)
    public function kitchenIngredients()
    {
        return $this->hasMany(Kitchen_order_ingredient::class);
    }
}
