<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Payroll extends Model
{
    //

    protected $fillable = [
        'employee_id',
        'pay_period',
        'basic_salary',
        'total_allowances',
        'total_deductions',
        'loan_deductions',
        'gross_pay',
        'net_pay',
    ];
    public function employee()
    {
        return $this->belongsTo(Employee::class, 'employee_id');
    }
    // Optional: convenience methods for calculations
    public function getTotalLoanDeductionsAttribute()
    {
        $total = 0;
        if ($this->employee) {
            foreach ($this->employee->loans as $loan) {
                foreach ($loan->deductions as $deduction) {
                    $total += $deduction->amount;
                }
            }
        }
        return $total;
    }

    public function getNetPayAttribute()
    {
        return $this->basic_salary + $this->total_allowances - $this->total_deductions - $this->total_loan_deductions;
    }
}
