<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Meal extends Model
{
    //
    protected $fillable = ['meal_name', 'description'];

    public function recipes()
    {
        return $this->belongsToMany(Recipe::class, 'meal_recipes')
            ->withPivot('quantity')
            ->withTimestamps();
    }
}
