<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Kitchen_order_ingredient extends Model
{
    //
    protected $fillable = [
        'kitchen_order_id',
        'product_id',
        'required_qty',
        'recipe_name',
        'source_type',
        'recipe_qty',
        'recipe_id',
        'unit_cost',
        'total_cost',
        'stock_available',
        'shortage_qty',
    ];


    // The order this ingredient belongs to
    public function order()
    {
        return $this->belongsTo(Kitchen_order::class, 'kitchen_order_id');
    }

    // The product/ingredient
    public function product()
    {
        return $this->belongsTo(Product::class);
    }
    public function recipe()
    {
        return $this->belongsTo(Recipe::class, 'recipe_id');
    }

    // Link ingredient to register
    public function register()
    {
        return $this->belongsTo(Register::class);
    }


}
