<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Kitchen_order extends Model
{
    //
    protected $fillable = [
        'order_no',
        'order_date',
        'chef_id',
        'recipe_id', // Optional if you want to track a main recipe
        'status',
        'total_cost',
        'remarks'
    ];

    // Chef who created this order (optional)
    public function chef()
    {
        return $this->belongsTo(User::class, 'chef_id');
    }

    // All items/ingredients in this order
    public function ingredients()
    {
        return $this->hasMany(Kitchen_order_ingredient::class, 'kitchen_order_id');
    }

    // Calculate total cost from ingredients
    public function getTotalCostAttribute()
    {
        return $this->ingredients->sum('total_cost');
    }
    public function recipe()
    {
        return $this->belongsTo(Recipe::class, 'recipe_id');
    }
    public function approvals()
    {
        return $this->hasMany(Kitchen_order_approval::class, 'kitchen_order_id');
    }

}
