<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Food extends Model
{
    //
    protected $guarded = [];

    public function ingredients()
    {
        return $this->belongsToMany(Product::class, 'food_ingredients')
            ->withPivot(['quantity', 'unit_id'])
            ->withTimestamps();
    }

    public function foodIngredients()
    {
        return $this->hasMany(FoodIngredient::class);
    }

    public function sales()
    {
        return $this->hasMany(Sale::class);
    }
}
