<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Employee extends Model
{
    protected $guarded = [];

    public function department()
    {
        return $this->belongsTo(Department::class);
    }

    public function designation()
    {
        return $this->belongsTo(Designation::class);
    }

    /*
    |--------------------------------------------------------------------------
    | Allowances (many per employee)
    |--------------------------------------------------------------------------
    */
    public function allowances()
    {
        return $this->belongsToMany(
            Allowance::class,
            'employee_allowances',
            'employee_id',
            'allowance_id'
        );
    }

    /*
    |--------------------------------------------------------------------------
    | Other deductions (many per employee)
    |--------------------------------------------------------------------------
    */
    public function deductions()
    {
        return $this->belongsToMany(
            Deduction::class,
            'employee_deductions',
            'employee_id',
            'deduction_id'
        );
    }

    /*
    |--------------------------------------------------------------------------
    | Loans
    |--------------------------------------------------------------------------
    */
    public function loans()
    {
        return $this->hasMany(Employee_loan::class);
    }

    public function payrolls()
    {
        return $this->hasMany(Payroll::class);
    }
}

