<?php

namespace App\Imports;

use App\Models\Employee;
use Maatwebsite\Excel\Concerns\ToModel;

class EmployeesImport implements ToModel
{
    /**
     * @param array $row
     *
     * @return \Illuminate\Database\Eloquent\Model|null
     */
    public function model(array $row)
    {
        $lastEmployee = Employee::latest()->first();
        $nextNumber = $lastEmployee ? $lastEmployee->id + 1 : 1;

        return new Employee([
            'employee_code' => 'EMP-' . str_pad($nextNumber, 4, '0', STR_PAD_LEFT),
            'full_name' => $row['full_name'],
            'gender' => $row['gender'],
            'department_id' => $row['department_id'],
            'designation_id' => $row['designation_id'],
            'basic_salary' => $row['basic_salary'],
            'hire_date' => $row['hire_date'],
            'status' => $row['status'] ?? 1,
        ]);
    }


}
