<?php

namespace App\Http\Middleware;

use App\Models\Register;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class EnsureRegisterIsOpen
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle($request, Closure $next)
    {
        $register = Register::where('user_id', auth()->id())
            ->where('status', 'open')
            ->first();

        if (!$register) {
            return redirect()
                ->route('register.open')
                ->with('error', 'You must open a register first');
        }

        return $next($request);
    }



}
