<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\Unit;
use App\Models\Unit_conversation;
use Carbon\Carbon;
use Illuminate\Http\Request;

class UnitController extends Controller
{
    //
    public function AllUnit(){

        $units = Unit::latest()->get();
        return view('backend.units.all_units',compact('units'));

    }// End Method
    public function StoreUnit(Request $request)
    {
        $request->validate([
            'unit_name'   => 'required|unique:units,unit_name',
            'unit_symbol' => 'required',
            'multiplier'  => 'nullable|numeric|min:0.0001',
            'base_unit_id'=> 'nullable|exists:units,id',
        ]);

        // 1. Save the unit ALWAYS
        $unit = Unit::create([
            'unit_name'   => $request->unit_name,
            'unit_symbol' => $request->unit_symbol,
        ]);

        // 2. ONLY if checkbox was checked
        if ($request->has('is_multiple')) {

            if (!$request->multiplier || !$request->base_unit_id) {
                return back()->withErrors('Please provide both a multiplier and a base unit.');
            }

            Unit_conversation::create([
                'parent_unit_id' => $unit->id,
                'child_unit_id'  => $request->base_unit_id,
                'multiplier'     => $request->multiplier, // <--- user input
            ]);
        }
        $notification = array(
            'message' => 'Unit Added Successfully',
            'alert-type' => 'success'
        );

        return back()->with($notification, 'Unit saved successfully');
    }
    public function EditUnit($id){

            $unit = Unit::with('parentConversions')->findOrFail($id);

            // get all other units for base_unit dropdown
            $units = Unit::where('id', '!=', $id)->get();

        return view('backend.units.edit_units',compact('unit','units'));

    }// End Method
    public function UpdateUnit(Request $request, $id)
    {
        $request->validate([
            'unit_name'    => 'required|string|unique:units,unit_name,' . $id,
            'unit_symbol'  => 'required|string',
            'multiplier'   => 'nullable|numeric|min:0.0001',
            'base_unit_id' => 'nullable|exists:units,id',
        ]);

        $unit = Unit::findOrFail($id);

        // update basic info
        $unit->update([
            'unit_name'   => $request->unit_name,
            'unit_symbol' => $request->unit_symbol,
        ]);

        // handle multiple logic
        $conversion = $unit->parentConversions;

        if ($request->has('is_multiple')) {

            if (!$request->multiplier || !$request->base_unit_id) {
                return back()->withErrors('Multiplier and Base Unit are required');
            }

            if ($unit->id == $request->base_unit_id) {
                return back()->withErrors('Unit cannot be its own base unit');
            }

            if ($conversion) {
                // update existing conversion
                $conversion->update([
                    'child_unit_id' => $request->base_unit_id,
                    'multiplier'    => $request->multiplier,
                ]);
            } else {
                // create new conversion
                Unit_conversation::create([
                    'parent_unit_id' => $unit->id,
                    'child_unit_id'  => $request->base_unit_id,
                    'multiplier'     => $request->multiplier,
                ]);
            }

        }
        $notification = array(
            'message' => 'Unit Updated Successfully',
            'alert-type' => 'success'
        );


        return redirect()->route('all.unit')->with($notification, 'Unit updated successfully');
    }

    public function DeleteUnit($id)
    {
        $unit = Unit::with('parentConversion')->findOrFail($id);

        // Delete conversion if exists
        if ($unit->parentConversion) {
            $unit->parentConversion->delete();
        }

        // Optional: also delete if this unit is a child in another conversion
        $childConversions = Unit_conversation::where('child_unit_id', $unit->id)->get();
        foreach ($childConversions as $conversion) {
            $conversion->delete();
        }

        // Delete the unit itself
        $unit->delete();

        return back()->with('success', 'Unit deleted successfully');
    }





}
