<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\Supplier;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Intervention\Image\Facades\Image;

class SupplierController extends Controller
{
    //
    public function AllSupplier(){

        $supplier = Supplier::latest()->get();
        return view('backend.supplier.all_supplier',compact('supplier'));

    } // End Method
    public function AddSupplier(){
        return view('backend.supplier.add_supplier');
    } // End Method

    public function StoreSupplier(Request $request){

        $validateData = $request->validate([
            'name' => 'required|max:200|unique:suppliers',
            'phone' => 'required|max:200',
            'location' => 'required|max:400',

        ]);

        Supplier::insert([
            'name' => $request->name,
            'phone' => $request->phone,
            'location' => $request->location,
            'created_at' => Carbon::now(),

        ]);

        $notification = array(
            'message' => 'Supplier Added Successfully',
            'alert-type' => 'success'
        );

        return redirect()->route('all.supplier')->with($notification);
    } // End Method

    public function EditSupplier($id){

        $supplier = Supplier::findOrFail($id);
        return view('backend.supplier.edit_supplier',compact('supplier'));

    } // End Method
    public function UpdateSupplier(Request $request){

        $supplier_id = $request->id;



            Supplier::findOrFail($supplier_id)->update([

                'name' => $request->name,
                'phone' => $request->phone,
                'location' => $request->location,
                'created_at' => Carbon::now(),

            ]);

            $notification = array(
                'message' => 'Supplier Updated Successfully',
                'alert-type' => 'success'
            );

            return redirect()->route('all.supplier')->with($notification);

    } // End Method


}
