<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\Meal;
use App\Models\Recipe;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class MealController extends Controller
{
    //
    // Show all meals
    public function index()
    {
        $meals = Meal::with('recipes')->get();
        return view('backend.meals.meal_index', compact('meals'));
    }

    // Show form to create a new meal
    public function create()
    {
        $recipes = Recipe::all();
        return view('backend.meals.meal_create', compact('recipes'));
    }

    // Save a new meal
    public function store(Request $request)
    {
        $request->validate([
            'meal_name' => 'required|string|max:255',
            'recipes' => 'required|array|min:1',
        ]);

        DB::transaction(function () use ($request) {
            // Create the meal
            $meal = Meal::create([
                'meal_name' => $request->meal_name,
            ]);

            // Attach recipes with quantities
            foreach ($request->recipes as $recipeId => $qty) {
                $meal->recipes()->attach($recipeId, ['quantity' => $qty]);
            }
        });

        return redirect()->route('meals.index')->with('success', 'Meal created successfully!');
    }

}
