<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\Food;
use App\Models\Food_ingredient;
use App\Models\FoodIngredient;
use App\Models\Product;
use App\Models\Purchases;
use App\Models\Recipe;
use App\Models\RecipeIngredients;
use App\Models\Supplier;
use App\Models\Unit;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class FoodController extends Controller
{
    //
    public function AllRecipe (){

        $recipes = Recipe::with([
            'unit',
            'ingredients.product'
        ])->get();
        return view('backend.recipe.all_recipe',compact('recipes'));
    }
    public function AddRecipe()
    {
        // Load units (for yield unit & ingredient units)
        $units = Unit::orderBy('unit_name')->get();
        // Load products that can be used as ingredients
        // Stock check optional at this stage
        $products = Product::with('purchases')->get();
        // Calculate average unit cost per product from purchases
        $products->each(function ($product) {
            $totalQty  = $product->purchases->sum('product_qty');
            $totalCost = $product->purchases->sum('buying_price');

            $product->unit_cost = $totalQty > 0
                ? $totalCost / $totalQty
                : 0;
        });
        return view('backend.recipe.add_recipe', compact('products','units'));
    }

    public function StoreRecipe(Request $request)
    {
        $request->validate([
            'recipe_name'     => 'required|string|unique:recipes,recipe_name',
            'yield_qty'     => 'required|numeric|min:1',
            'yield_unit_id' => 'required|exists:units,id',
            'product_id'    => 'required|array',
            'quantity'      => 'required|array'
        ]);

        DB::transaction(function () use ($request) {

            $totalProductionCost = 0;

            // 1️⃣ Create the food first (without costs)
            $food = Recipe::create([
                'recipe_name'      => $request->recipe_name,
                'yield_qty'      => $request->yield_qty,
                'yield_unit_id'  => $request->yield_unit_id,
                'production_cost'=> 0, // will calculate below
                'unit_cost'      => 0  // will calculate below
            ]);

            // 2️⃣ Loop through ingredients
            foreach ($request->product_id as $i => $productId) {

                $qtyUsed = $request->quantity[$i];

                // 🔥 Get latest purchases for the product
                $purchases = Purchases::where('product_id', $productId)->get();

                $totalQtyPurchased = $purchases->sum('product_qty');
                $totalPurchaseCost = $purchases->sum('buying_price');

//                if ($totalQtyPurchased <= 0) {
//                    throw new \Exception("No purchase history for product ID {$productId}");
//                }

                // ✅ Weighted average unit cost
                $unitCost = 0;

                // Ingredient cost
                $ingredientCost = $unitCost * $qtyUsed;
                $totalProductionCost += $ingredientCost;

                // 3️⃣ Save ingredient to pivot table
                RecipeIngredients::create([
                    'recipe_id'    => $food->id,
                    'product_id' => $productId,
                    'quantity'   => $qtyUsed,
                    'unit_cost'  => $unitCost,
                    'total_cost' => $ingredientCost
                ]);
            }

            // 4️⃣ Update the food costs after looping ingredients
            $food->update([
                'production_cost' => $totalProductionCost,
                'unit_cost'       => $totalProductionCost / $request->yield_qty
            ]);
        });
        $notification = array(
            'message' => 'Recipe  Added Successfully',
            'alert-type' => 'success'
        );
        return redirect()->back()->with($notification);
    }




}
