<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\Employee;
use App\Models\Employee_loan;
use App\Models\Employee_loan_deduction;
use Illuminate\Http\Request;

class EmployeeLoanController extends Controller
{
    //
    public function index()
    {
        return view('backend.employee_loans.employee_index', [
            'employees' => Employee::orderBy('full_name')->get(),
            'loans' => Employee_loan::with(['employee','deductions'])->latest()->get(),
        ]);
    }

    public function store(Request $request)
    {
        $request->validate([
            'employee_id' => 'required|exists:employees,id',
            'type' => 'required|in:loan,advance',
            'amount' => 'required|numeric|min:1',
        ]);

        Employee_loan::create([
            'employee_id' => $request->employee_id,
            'type' => $request->type,
            'amount' => $request->amount,
            'remaining_amount' => $request->amount,
        ]);

        return redirect()->route('employee.loans.index')
            ->with('success','Loan/Advance added successfully');
    }

    public function deduct(Request $request, Employee_loan $loan)
    {
        $request->validate([
            'amount' => 'required|numeric|min:1|max:' . $loan->remaining_amount,
        ]);

        Employee_loan_deduction::create([
            'employee_loan_id' => $loan->id,
            'amount' => $request->amount,
            'deduction_date' => now(),
        ]);

        $loan->decrement('remaining_amount', $request->amount);

        return back()->with('success','Deduction recorded');
    }
    // List all loans


    // Show form to create new loan/advance for employee
    public function create($employee_id)
    {
        $employee = Employee::findOrFail($employee_id);
        return view('backend.employee_loans.employee_create', compact('employee'));
    }

//    // Store loan/advance
//    public function store(Request $request)
//    {
//        $request->validate([
//            'employee_id' => 'required|exists:employees,id',
//            'type' => 'required|in:loan,advance',
//            'amount' => 'required|numeric|min:1',
//            'description' => 'nullable|string',
//        ]);
//
//        Employee_loan::create([
//            'employee_id' => $request->employee_id,
//            'type' => $request->type,
//            'amount' => $request->amount,
//            'remaining_amount' => $request->amount,
//            'description' => $request->description,
//        ]);
//
//        return redirect()->route('employee_loans.employee_index')->with('success','Loan/Advance added successfully.');
//    }
//
//    // Deduct an amount from loan/advance
//    public function deduct(Request $request, $loan_id)
//    {
//        $loan = Employee_loan::findOrFail($loan_id);
//
//        $request->validate([
//            'amount' => 'required|numeric|min:1|max:' . $loan->remaining_amount,
//        ]);
//
//        // Create deduction record
//        $loan->deductions()->create([
//            'amount' => $request->amount,
//            'deduction_date' => now(),
//        ]);
//
//        // Update remaining_amount
//        $loan->remaining_amount -= $request->amount;
//        $loan->save();
//
//        return redirect()->back()->with('success','Loan deduction recorded successfully.');
//    }
}
