<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\Department;
use App\Models\Designation;
use Illuminate\Http\Request;

class DesignationController extends Controller
{
    //
    public function index()
    {
        $designations = Designation::with('department')->latest()->get();
        $departments = Department::where('status', 1)->get();

        return view('backend.designations.designation_index', compact('designations','departments'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'department_id' => 'required|exists:departments,id',
            'name' => 'required',
        ]);

        Designation::create($request->all());
        $notification = [
            'message' => 'Designation Stored Successfully',
            'alert-type' => 'success',
        ];


        return redirect()->back()->with($notification);
    }

    public function update(Request $request, $id)
    {
        Designation::findOrFail($id)->update($request->all());
        $notification = [
            'message' => 'Designation Updated Successfully',
            'alert-type' => 'success',
        ];
        return redirect()->back()->with($notification);
    }

    public function destroy($id)
    {
        Designation::findOrFail($id)->delete();

        return redirect()->back()->with('success', 'Designation deleted');
    }
}
