<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;

use App\Models\Payroll;

use Maatwebsite\Excel\Concerns\WithHeadings;

class MonthlyPayrollExport implements FromCollection, WithHeadings
{
    protected $year;
    protected $month;

    public function __construct($year, $month)
    {
        $this->year  = $year;
        $this->month = $month;
    }

    public function collection()
    {
        return Payroll::with('employee')
            ->whereYear('pay_period', $this->year)
            ->whereMonth('pay_period', $this->month)
            ->get()
            ->map(function ($pay) {
                return [
                    'Employee'        => $pay->employee->full_name ?? '',
                    'Basic Salary'    => $pay->basic_salary,
                    'Allowances'      => $pay->total_allowances,
                    'Gross Pay'       => $pay->gross_pay,
                    'Deductions'      => $pay->total_deductions,
                    'Loan Deductions' => $pay->loan_deductions,
                    'Net Pay'         => $pay->net_pay,
                ];
            });
    }

    public function headings(): array
    {
        return [
            'Employee',
            'Basic Salary',
            'Allowances',
            'Gross Pay',
            'Deductions',
            'Loan Deductions',
            'Net Pay'
        ];
    }
}

