<?php

namespace App\Exports;

use App\Models\Employee;
use Maatwebsite\Excel\Concerns\FromCollection;

class EmployeesExport implements FromCollection
{
    /**
    * @return \Illuminate\Support\Collection
    */

    public function collection()
    {
        return Employee::select(
            'employee_code',
            'full_name',
            'gender',
            'department_id',
            'designation_id',
            'basic_salary',
            'hire_date',
            'status'
        )->get();
    }

    public function headings(): array
    {
        return [
            'Employee Code',
            'Full Name',
            'Gender',
            'Department ID',
            'Designation ID',
            'Basic Salary',
            'Hire Date',
            'Status',
        ];
    }

}
